<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);



// Conexiones a las bases de datos
$local_conn = new mysqli('localhost', 'aliment5_root', 'pluton007$', 'aliment5_doli2');
$remote_conn = new mysqli('198.50.175.169', 'guayoyoc_root', 'pluton007$', 'guayoyoc_doli2');

// Verificar conexiones
if ($local_conn->connect_error) {
    die("Conexión local fallida: " . $local_conn->connect_error);
}
if ($remote_conn->connect_error) {
    die("Conexión remota fallida: " . $remote_conn->connect_error);
}

// Consultas para obtener datos
// Consulta para RIGA (Local)
$riga_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre, 
    COUNT(DISTINCT s.nom) AS cantidad_clientes,
    SUM(f.total) AS total_ventas
FROM 
    llx_societe AS s 
LEFT JOIN 
    llx_societe_extrafields AS extra ON s.rowid = extra.fk_object 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
LEFT JOIN 
    llx_facture AS f ON s.rowid = f.fk_soc
WHERE 
    s.status = 1 
    AND us.fk_usergroup = 1
    AND f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
    AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY
GROUP BY 
    nombre;
";

$riga_result = $local_conn->query($riga_query);

// Calcular el total de ventas para el porcentaje
$total_ventas_riga = 0;
$total_cantidad_riga = 0; // Para totalizar cantidad
while ($row = $riga_result->fetch_assoc()) {
    $total_ventas_riga += $row['total_ventas'];
    $total_cantidad_riga += $row['cantidad_clientes']; // Sumar cantidad
}
$riga_result->data_seek(0); // Reiniciar el puntero de resultados

// Consulta para GUAYOYO (Remoto)
$guayoyo_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre,
    COUNT(DISTINCT s.nom) AS cantidad_clientes,
    SUM(f.total) AS TotalFacturas
FROM 
    llx_facture AS f 
LEFT JOIN 
    llx_societe AS s ON f.fk_soc = s.rowid 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
WHERE 
    f.entity IN (1) 
    AND us.fk_usergroup = 1
    AND f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
    AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
    AND f.fk_statut IN (1, 2) 
GROUP BY 
    nombre;
";

$guayoyo_result = $remote_conn->query($guayoyo_query);

// Consulta para obtener Asesores sin Venta en RIGA
$sin_venta_riga_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre
FROM 
    llx_user AS u
LEFT JOIN 
    llx_societe_commerciaux AS sc ON u.rowid = sc.fk_user
LEFT JOIN 
    llx_societe AS s ON sc.fk_soc = s.rowid
LEFT JOIN 
    llx_facture AS f ON s.rowid = f.fk_soc 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
WHERE 
    s.status = 1 
    AND u.statut = 1 
    AND us.fk_usergroup = 1
GROUP BY 
    nombre
HAVING 
    COUNT(CASE WHEN f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
                AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
           THEN f.rowid END) = 0;
";

$sin_venta_riga_result = $local_conn->query($sin_venta_riga_query);

// Consulta para obtener Asesores sin Venta en GUAYOYO
$sin_venta_guayoyo_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre
FROM 
    llx_user AS u
LEFT JOIN 
    llx_societe_commerciaux AS sc ON u.rowid = sc.fk_user
LEFT JOIN 
    llx_societe AS s ON sc.fk_soc = s.rowid
LEFT JOIN 
    llx_facture AS f ON s.rowid = f.fk_soc 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
WHERE 
    s.status = 1 
    AND u.statut = 1 
    AND us.fk_usergroup = 1
GROUP BY 
    nombre
HAVING 
    COUNT(CASE WHEN f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
                AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
           THEN f.rowid END) = 0;
";

$sin_venta_guayoyo_result = $remote_conn->query($sin_venta_guayoyo_query);

// Calcular el total de ventas para el porcentaje
$total_facturas_guayoyo = 0;
$total_cantidad_guayoyo = 0; // Para totalizar cantidad
while ($row = $guayoyo_result->fetch_assoc()) {
    $total_facturas_guayoyo += $row['TotalFacturas'];
    $total_cantidad_guayoyo += $row['cantidad_clientes']; // Sumar cantidad
}
$guayoyo_result->data_seek(0); // Reiniciar el puntero de resultados

// Consulta para obtener todos los vendedores de RIGA
$vendedores_riga_query = "
SELECT u.rowid as rowid, CONCAT(u.firstname, ' ', u.lastname) as nombre 
FROM llx_user as u 
LEFT JOIN llx_usergroup_user as us ON u.rowid = us.fk_user
WHERE u.statut = 1
AND u.firstname != ''
AND us.fk_usergroup = 1";

$vendedores_riga_result = $local_conn->query($vendedores_riga_query);
$vendedores_riga_data = [];
while ($row = $vendedores_riga_result->fetch_assoc()) {
    $vendedores_riga_data[] = $row;
}

// Consulta para obtener todos los vendedores de GUAYOYO
$vendedores_guayoyo_query = "
SELECT u.rowid as rowid, CONCAT(u.firstname, ' ', u.lastname) as nombre 
FROM llx_user as u 
LEFT JOIN llx_usergroup_user as us ON u.rowid = us.fk_user
WHERE u.statut = 1
AND u.firstname != ''
AND us.fk_usergroup = 1";

$vendedores_guayoyo_result = $remote_conn->query($vendedores_guayoyo_query);
$vendedores_guayoyo_data = [];
while ($row = $vendedores_guayoyo_result->fetch_assoc()) {
    $vendedores_guayoyo_data[] = $row;
}

// Obtener Asesores sin Venta en RIGA
$sin_venta_riga_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre
FROM 
    llx_user AS u
LEFT JOIN 
    llx_societe_commerciaux AS sc ON u.rowid = sc.fk_user
LEFT JOIN 
    llx_societe AS s ON sc.fk_soc = s.rowid
LEFT JOIN 
    llx_facture AS f ON s.rowid = f.fk_soc 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
WHERE 
    s.status = 1 
    AND u.statut = 1 
    AND us.fk_usergroup = 1
GROUP BY 
    nombre
HAVING 
    COUNT(CASE WHEN f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
                AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
           THEN f.rowid END) = 0;
";

$sin_venta_riga_result = $local_conn->query($sin_venta_riga_query);

// Obtener Asesores sin Venta en GUAYOYO
$sin_venta_guayoyo_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre
FROM 
    llx_user AS u
LEFT JOIN 
    llx_societe_commerciaux AS sc ON u.rowid = sc.fk_user
LEFT JOIN 
    llx_societe AS s ON sc.fk_soc = s.rowid
LEFT JOIN 
    llx_facture AS f ON s.rowid = f.fk_soc 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
WHERE 
    s.status = 1 
    AND u.statut = 1 
    AND us.fk_usergroup = 1
GROUP BY 
    nombre
HAVING 
    COUNT(CASE WHEN f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
                AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
           THEN f.rowid END) = 0;
";

$sin_venta_guayoyo_result = $remote_conn->query($sin_venta_guayoyo_query);

// Lógica para obtener las ventas por volumen de RIGA y GUAYOYO
$ventasVolumenDataRiga = [];
$ventasVolumenDataGuayoyo = [];

// Función para obtener datos de ventas por volumen
function obtenerVentasPorVolumen($conn, $vendedoresData, &$ventasVolumenData) {
    foreach ($vendedoresData as $vendedor) {
        $vendedorId = $vendedor['rowid'];
        
        $sqlVolumen = 'SELECT DISTINCT 
            y.label AS Categoria, 
            IF(y.label = "embutidos", 
                SUM(CASE WHEN p.rowid IN ("112", "37", "137", "120", "142") THEN fd.qty ELSE fd.qty * 10 END), 
                SUM(fd.qty)
            ) AS Cantidad 
        FROM 
            llx_societe AS s 
        LEFT JOIN 
            llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
        LEFT JOIN 
            llx_user AS u ON sc.fk_user = u.rowid 
        LEFT JOIN 
            llx_facture AS f ON f.fk_soc = s.rowid 
        LEFT JOIN 
            llx_facturedet AS fd ON f.rowid = fd.fk_facture 
        LEFT JOIN 
            llx_product AS p ON fd.fk_product = p.rowid 
        LEFT JOIN 
            llx_categorie_product AS cp ON cp.fk_product = p.rowid 
        LEFT JOIN 
            llx_categorie AS y ON y.rowid = cp.fk_categorie 
        WHERE 
            u.rowid = ' . $vendedorId . ' 
            AND f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
            AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
        GROUP BY 
            Categoria 
        ORDER BY 
            Categoria';

        $resqlVolumen = $conn->query($sqlVolumen);
        if ($resqlVolumen) {
            while ($row = $resqlVolumen->fetch_object()) {
                if (!isset($ventasVolumenData[$vendedorId])) {
                    $ventasVolumenData[$vendedorId] = [];
                }
                $ventasVolumenData[$vendedorId][$row->Categoria] = $row->Cantidad;
            }
        }
    }
}

// Obtener datos de ventas por volumen para RIGA
obtenerVentasPorVolumen($local_conn, $vendedores_riga_data, $ventasVolumenDataRiga);
// Obtener datos de ventas por volumen para GUAYOYO
obtenerVentasPorVolumen($remote_conn, $vendedores_guayoyo_data, $ventasVolumenDataGuayoyo);

// Convertir datos a JSON
$ventasVolumenJSON_Riga = json_encode($ventasVolumenDataRiga);
$ventasVolumenJSON_Guayoyo = json_encode($ventasVolumenDataGuayoyo);

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@latest"></script>
    <title>Seguimiento diario a Vendedores</title>
    <style>
        body {
            margin: 100px;
            padding: 0;
            font-family: Arial, sans-serif; /* Establece una fuente por defecto */
        }
        .container {
            margin: 0 20px; /* Ajusta el margen izquierdo y derecho */
        }
        .progress-bar {
            height: 10px;
            border-radius: 5px;
        }
        .bar-container {
            background-color: #e0e0e0; /* Color de fondo de la barra */
            border-radius: 5px;
            overflow: hidden;
            height: 10px;
            width: 100%;
        }
        /* Estilos para las tablas */
        .riga-table {
            background-color: #fff3e0; /* Fondo claro */
        }
        .riga-header {
            background-color: #ff9800; /* Naranja */
            color: white;
        }
        .guayoyo-table {
            background-color: #e3f2fd; /* Fondo claro */
        }
        .guayoyo-header {
            background-color: #2196f3; /* Azul */
            color: white;
        }
        /* Ancho de las columnas */
        .riga-table th, .guayoyo-table th {
            width: 25%; /* Ancho para todas las columnas */
        }
    </style>
</head>
<body>
    <div class="p-6 bg-background text-foreground">
        <h1 class="text-2xl font-bold mb-4">Seguimiento diario a Vendedores</h1>
        <h2 class="text-xl mb-2">Activación y Venta</h2>
        <p class="text-muted-foreground mb-6"><?php echo date('l, d \d\e F \d\e Y'); ?></p>

        <div class="mb-8">
            <h3 class="text-lg font-semibold bg-secondary text-secondary-foreground p-2">DISTRIBUIDORARIGA0803,C.A. (Semana en Curso)</h3>
            <table class="min-w-full border-collapse border border-border riga-table">
                <thead>
                    <tr class="riga-header">
                        <th class="border border-border p-2">Asesor Comercial</th>
                        <th class="border border-border p-2">Activación</th>
                        <th class="border border-border p-2">Cantidad</th>
                        <th class="border border-border p-2">% del total de venta</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $riga_result->fetch_assoc()): ?>
                    <tr>
                        <td class="border border-border p-2"><?php echo $row['nombre']; ?></td>
                        <td class="border border-border p-2">
                            <?php
                            $activacion_porcentaje = ($row['cantidad_clientes'] / $total_cantidad_riga) * 100;
                            echo number_format($row['cantidad_clientes'], 0);
                            ?>
                            <div class="bar-container">
                                <div class="progress-bar" style="width: <?php echo number_format($activacion_porcentaje, 2); ?>%; background-color: #ff9800;"></div>
                            </div>
                        </td>
                        <td class="border border-border p-2"><?php echo number_format($row['total_ventas'], 2); ?></td>
                        <td class="border border-border p-2">
                            <?php
                            $porcentaje = ($row['total_ventas'] / $total_ventas_riga) * 100;
                            echo number_format($porcentaje, 2) . '%';
                            ?>
                            <div class="bar-container">
                                <div class="progress-bar" style="width: <?php echo number_format($porcentaje, 2); ?>%; background-color: #ff9800;"></div>
                            </div>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                    <tr class="font-bold">
                        <td class="border border-border p-2">Total General</td>
                        <td class="border border-border p-2"><?php echo number_format($total_cantidad_riga, 0); ?></td>
                        <td class="border border-border p-2"><?php echo number_format($total_ventas_riga, 2); ?></td>
                        <td class="border border-border p-2">100%</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div>
            <h3 class="text-lg font-semibold bg-secondary text-secondary-foreground p-2">GUAYOYO76,C.A. (Semana en Curso)</h3>
            <table class="min-w-full border-collapse border border-border guayoyo-table">
                <thead>
                    <tr class="guayoyo-header">
                        <th class="border border-border p-2">Asesor Comercial</th>
                        <th class="border border-border p-2">Activación</th>
                        <th class="border border-border p-2">Cantidad</th>
                        <th class="border border-border p-2">% del total de venta</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $guayoyo_result->fetch_assoc()): ?>
                    <tr>
                        <td class="border border-border p-2"><?php echo $row['nombre']; ?></td>
                        <td class="border border-border p-2">
                            <?php
                            $activacion_porcentaje = ($row['cantidad_clientes'] / $total_cantidad_guayoyo) * 100;
                            echo number_format($row['cantidad_clientes'], 0);
                            ?>
                            <div class="bar-container">
                                <div class="progress-bar" style="width: <?php echo number_format($activacion_porcentaje, 2); ?>%; background-color: #2196f3;"></div>
                            </div>
                        </td>
                        <td class="border border-border p-2"><?php echo number_format($row['TotalFacturas'], 2); ?></td>
                        <td class="border border-border p-2">
                            <?php
                            $porcentaje = ($row['TotalFacturas'] / $total_facturas_guayoyo) * 100;
                            echo number_format($porcentaje, 2) . '%';
                            ?>
                            <div class="bar-container">
                                <div class="progress-bar" style="width: <?php echo number_format($porcentaje, 2); ?>%; background-color: #2196f3;"></div>
                            </div>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                    <tr class="font-bold">
                        <td class="border border-border p-2">Total General</td>
                        <td class="border border-border p-2"><?php echo number_format($total_cantidad_guayoyo, 0); ?></td>
                        <td class="border border-border p-2"><?php echo number_format($total_facturas_guayoyo, 2); ?></td>
                        <td class="border border-border p-2">100%</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div>
            <h3 class="text-lg font-semibold bg-secondary text-secondary-foreground p-2">Asesores sin Ventas</h3>
            <h4 class="font-semibold">RIGA</h4>
            <ul>
                <?php while ($row = $sin_venta_riga_result->fetch_assoc()): ?>
                    <li><?php echo $row['nombre']; ?></li>
                <?php endwhile; ?>
            </ul>
            <h4 class="font-semibold">GUAYOYO</h4>
            <ul>
                <?php while ($row = $sin_venta_guayoyo_result->fetch_assoc()): ?>
                    <li><?php echo $row['nombre']; ?></li>
                <?php endwhile; ?>
            </ul>
        </div>

        <div>
            <h3 class="text-lg font-semibold bg-secondary text-secondary-foreground p-2">Gráficos de Ventas por Volumen</h3>
            <canvas id="ventasRiga" width="400" height="200"></canvas>
            <canvas id="ventasGuayoyo" width="400" height="200"></canvas>
        </div>

        <script>
            const ventasRigaData = <?php echo $ventasVolumenJSON_Riga; ?>;
            const ventasGuayoyoData = <?php echo $ventasVolumenJSON_Guayoyo; ?>;

            // Gráfico de ventas RIGA
            const ctxRiga = document.getElementById('ventasRiga').getContext('2d');
            const rigaLabels = Object.keys(ventasRigaData).map(id => ventasRigaData[id].n);
            const rigaData = rigaLabels.map(label => ventasRigaData[label]);

            new Chart(ctxRiga, {
                type: 'bar',
                data: {
                    labels: rigaLabels,
                    datasets: [{
                        label: 'Ventas por Volumen',
                        data: rigaData,
                        backgroundColor: 'rgba(255, 152, 0, 0.5)',
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });

            // Gráfico de ventas GUAYOYO
            const ctxGuayoyo = document.getElementById('ventasGuayoyo').getContext('2d');
            const guayoyoLabels = Object.keys(ventasGuayoyoData).map(id => ventasGuayoyoData[id].n);
            const guayoyoData = guayoyoLabels.map(label => ventasGuayoyoData[label]);

            new Chart(ctxGuayoyo, {
                type: 'bar',
                data: {
                    labels: guayoyoLabels,
                    datasets: [{
                        label: 'Ventas por Volumen',
                        data: guayoyoData,
                        backgroundColor: 'rgba(33, 150, 243, 0.5)',
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        </script>
    </div>
</body>
</html>